-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/tittle_style.lua" );
require("scripts/luadebug.lua");
dofile("scripts/definitions/tutorial.lua");
dofile("scripts/definitions/new_feature_intro_level_dialog.lua");
require("scripts/definitions/sbfitnessdefines.lua");


MakeDialog
{
	name="LevelDialogGenerator",

		OlympusLayerWindow
		{
			name="GameLayerWindow",
			x = 0, y = 0, w = 800, h = 600,	
			
			
			Bitmap
			{
				name="backgroundimage",
				image="assets/images/backgrounds/themes/olympus/gym_olympus",
				
				Bitmap
				{
					x = 435,
					y = 0,
					name="upgradeshower01",
					image="assets/images/backgrounds/themes/olympus/olympus_upgrades_03",
				},
				
				Bitmap
				{
					x = 182,
					y = 165,
					name="upgradefloor01",
					image="assets/images/backgrounds/themes/olympus/olympus_upgrades_05",
				},
				
				Bitmap
				{
					x = 471,
					y = 391,
					name="upgradefloor02",
					image="assets/images/backgrounds/themes/olympus/olympus_upgrades_10",
				},				
				
				-- This construct the TGameLevel object
				GameWindow
				{ 
					name="GameWindow",
					x = 0, y = 0, w = kMax, h = kMax,			
					
	-- Skip tutorial button
					
					SetStyle(FitnessButtonStyleTittleXLBlueTxInside),
					SBButton{
							x=0,
							y=800,
							name="skiptutorial",
							label="ui.dialog.skiptutorial.label",
							
							command = 
						 		function()
						 			SkipTutorial();
						 		end
							
					},
					SetStyle(FitnessButtonStyleTittleSmallBlue2),
	-- the menu button
	
					SBButton{
							x=0,
							y=800,
							name="menu",
							label="hud.label.menu",
							type = kPush,
							flags = kHAlignCenter + kVAlignTop,
							icon="assets/images/ui/buttons/icon/iconmoregames",
							command = 
								function()
									SendGameMessage("ui.game.pause");
								end
							
					},
				--	Text
				--	{
				--		font = SmallFont,
				--		x=0,
				--		name="menutx",
				--		y=800,
				--		flags = kHAlignCenter + kVAlignCenter,
				--		label="hud.label.menu",
				--	};
										
														
				};	
	
		-- Continue button in tutorial
					SetStyle(FitnessButtonStyleTittleSmallBlueFlashing),	
					SBButton{
							x=0,
							y=0,
							icon="assets/images/ui/buttons/icon/iconnexttuto",
							name="ContinueTutorial",
							font = IngameFont,
							command = 
							 	function()
							 		ButtonContinue();
							 	end		
			
					},
					Text
					{
						font = IngameFont,
						x=0,
						name="ContinueTutorialtx",
						y=800,
						flags = kHAlignRight + kVAlignCenter,
						label="next",
					};
			-- the End Upgrade button
					SBButton{
							buttonAttribut	= FitnessButtonStyleTittleSourceSmallBlueFlash2,
							x=0,
							y=800,
							name="EndUpgradeMode",
							label="common.play.label",
							icon="assets/images/ui/buttons/icon/iconplay",
							command = 
								function()
									EndUpgradeMode();
								end
					};
					SetStyle(FitnessButtonStyleTittleSmallBlue2),
	
	-- the Decor button
					SBButton{
							x=0,
							y=800,
							name="DecorButton",
							label="common.decor.label",
							icon="assets/images/ui/buttons/icon/iconupgrade",
							command = 
								function()
									DoModal("scripts/decors.lua");
								end
					};
					SetStyle(FitnessButtonStyleTittleXLBlueTxInside),			
					-- the upgrade button
					SBButton{
							x=120,
							y=225,
							font = MenuButtonFont2,
							name="BuyUpgrade",
							label="upgrade.button",
							command = 
								function()
									UpgradeItem();
								end
							
					},
					-- the cancel upgrade button
					SBButton{
							x=100,
							y=100,
							font = MenuButtonFont2,
							name="CancelUpgrade",
							label="common.cancel.label",
							command = 
								function()
									CancelUpgrade();
								end
							
					},

					 SBButton{
					 	x=150, 
					 	y=800,
					 	font = MenuButtonFont,
					 	name="upgrade",
					 	label="upgradetitle",
						 command = 
						 	function()
						 		OpenArcadeUpgrade();
						 	end
					 },	
			},		
		},		
}